



<html>
<head>
  <title>javabog.dk -  - Netv&aelig;rkskommunikation</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel15.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel17.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>

<H1 CLASS="western" STYLE=""><FONT SIZE=6>16 <a name='afsn16'></a>Netv&aelig;rkskommunikation</FONT></H1>
<P CLASS="kapiteloversigt-western">Indhold:</P>
<UL>
  <LI><P CLASS="kapiteloversigt-western">At koble til en tjeneste p&aring;
  en fjernmaskine</P>
  <LI><P CLASS="kapiteloversigt-western">At udbyde tjenester p&aring;
  netv&aelig;rket</P>
  <LI><P CLASS="kapiteloversigt-western">URL-klassen og dens
  muligheder</P>
  <LI><P CLASS="kapiteloversigt-western">Eksempler: Hente en
  hjemmeside og en webserver</P>
</UL>
<P CLASS="kapiteloversigt-western">Kapitlet foruds&aelig;ttes ikke i
resten af bogen.</P>
<P CLASS="kapiteloversigt-western">Foruds&aelig;tter 15, Datastr&oslash;mme og filh&aring;ndtering.</P>


<P CLASS="western" STYLE="">Alle maskiner p&aring;
et TCP-IP-netv&aelig;rk, f.eks. internettet, har et IP-nummer. Det er
en talr&aelig;kke p&aring; fire byte<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>,
der unikt identificerer en maskine p&aring; nettet, f.eks.
195.215.15.20.</P>
<P CLASS="western">Normalt bruger man en navnetjeneste (eng.: Domain
Name Service - DNS), der sammenholder alle numre med navne, der
er nemmere at huske, f.eks. www.cv.ihk.dk eller www.esperanto.dk.
Adressen localhost (IP-nummer 127.0.0.1) er speciel ved altid at pege
p&aring; den maskine, man selv sidder ved.</P>
<P CLASS="western">Kommunikation mellem to maskiner sker ved, at
v&aelig;rtsmaskinen (eng.: host) g&oslash;r en tjeneste (eng.:
service) tilg&aelig;ngelig p&aring; en bestemt port, hvorefter
klienter kan &aring;bne en forbindelse til tjenesten. 
</P>
<P CLASS="western" ALIGN=CENTER><IMG SRC="bog17_html_2b6fe235.gif" NAME="Objekt17" ALIGN=MIDDLE HSPACE=2></P>
<P CLASS="western">Hjemmesider (HTTP-tjenesten) er tilg&aelig;ngelige
p&aring; port 80. Filoverf&oslash;rsel (FTP-tjenesten) er p&aring;
port 21 og hvis man vil logge ind p&aring; maskinen
(telnet-tjenesten), er det port 23.</P>
<P CLASS="western">I det f&oslash;lgende vil vi vise, hvordan man
bruger og udbyder HTTP-tjenesten til hjemmesider, men andre
former for netv&aelig;rkskommunikation foreg&aring;r p&aring;
lignende m&aring;der.</P>
<H2 CLASS="western">16.1 <a name='afsn16.1'></a>At forbinde til en port</SPAN></H2>
<P CLASS="western">Man opretter en forbindelse ved at oprette et
Socket-objekt<A CLASS="sdfootnoteanc" NAME="sdfootnote2anc" HREF="#sdfootnote2sym"><SUP>2</SUP></A>
og angive v&aelig;rtsmaskinen og porten i konstrukt&oslash;ren. Vil
man f.eks. kontakte webserveren p&aring; www.esperanto.dk, skriver
man:</P>
<PRE CLASS="kode-western">  Socket forbindelse = new Socket(&quot;www.esperanto.dk&quot;,80);</PRE><P CLASS="western">
Hvis alt gik godt, har Socket-objektet (forbindelsen eller &quot;soklen&quot;)
nu kontakt med v&aelig;rtsmaskinen (ellers har den kastet en
undtagelse).</P>
<P CLASS="western">Nu skal vi have fat i datastr&oslash;mmene fra os
til v&aelig;rten og fra v&aelig;rten til os:</P>
<PRE CLASS="kode-western">  OutputStream bin&aelig;rUd  = forbindelse.getOutputStream();
  InputStream  bin&aelig;rInd = forbindelse.getInputStream();</PRE><P CLASS="western">
Hvis vi vil sende/modtage bin&aelig;re data, kan vi nu bare g&aring;
i gang: bin&aelig;rUd.write() sender en byte eller en r&aelig;kke af
byte til v&aelig;rten og bin&aelig;rInd.read() modtager en eller
flere byte.</P>
<P CLASS="western">Hvis det er tekstkommunikation, er PrintWriter og
BufferedReader (der arbejder med tegn og strenge som beskrevet i
<a href='kapitel15.jsp'>kapitel 15</a>) dog nemmere at bruge:</P>
<PRE CLASS="kode-western">  PrintWriter    ud  = new PrintWriter(bin&aelig;rUd);
  BufferedReader ind = new BufferedReader(new InputStreamReader(bin&aelig;rInd));</PRE><P CLASS="western">
Nu kan vi f.eks. bede om startsiden (svarende til
<A CLASS="western" HREF="http://www.esperanto.dk/index.html">http://www.esperanto.dk/index.html</A>)
ved at sende &quot;GET&nbsp;/index.html&nbsp;HTTP/0.9&quot;, 
&quot;Host:&nbsp;www.esperanto.dk&quot; og en blank linje:</P>
<PRE CLASS="kode-western">  ud.println(&quot;GET /index.html HTTP/0.9&quot;);
  ud.println(&quot;Host: www.esperanto.dk&quot;);
  ud.println();
  ud.flush();</PRE><P CLASS="western">
Kaldet til flush() sikrer, at alle data er sendt til v&aelig;rten,
ved at t&oslash;mme eventuelle buffere.</P>
<P CLASS="western">Nu sender v&aelig;rten svaret, der kan l&aelig;ses
fra inddatastr&oslash;mmen<A CLASS="sdfootnoteanc" NAME="sdfootnote3anc" HREF="#sdfootnote3sym"><SUP>3</SUP></A>:</P>
<PRE CLASS="kode-western">  String <B>s = ind.readLine()</B>;
  <B>while (s != null) {</B>
    System.out.println(&quot;modt: &quot;+s);
<B>    s = ind.readLine();</B>
<B>  }</B></PRE><P CLASS="western">
While-l&oslash;kken bliver ved med at l&aelig;se linjer. N&aring;r
der ikke er flere data (v&aelig;rten har sendt alle data og lukket
forbindelsen), returnerer ind.readLine() null og l&oslash;kken
afbrydes.</P>
<P CLASS="western">Her er hele programmet:</P>
<PRE CLASS="kode-western">import java.io.*;
import java.net.*;
public class HentHjemmeside
{
  public static void main(String[] arg)
  {
    try {
      Socket <B>forbindelse = new Socket(&quot;www.esperanto.dk&quot;,80)</B>;
      OutputStream bin&aelig;rUd  = <B>forbindelse.getOutputStream()</B>;
      InputStream  bin&aelig;rInd = <B>forbindelse.getInputStream()</B>;
      PrintWriter    ud  = new PrintWriter(bin&aelig;rUd);
      BufferedReader ind = new BufferedReader(new InputStreamReader(bin&aelig;rInd));
      ud.println(&quot;GET /index.html HTTP/0.9&quot;);
      ud.println(&quot;Host: www.esperanto.dk&quot;);
      ud.println();
      <B>ud.flush()</B>;              <I>// send anmodning afsted til v&aelig;rten</I>
      String s = ind.readLine();
      while (s != null) {      <I>// readLine() giver null n&aring;r datastr&oslash;mmen lukkes</I>
        System.out.println(&quot;modt: &quot;+s);
        s = ind.readLine();
      }
      <B>forbindelse.close()</B>;
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">modt: HTTP/1.1 200 OK
modt: Date: Tue, 17 Apr 2001 13:06:06 GMT
modt: Server: Apache/1.3.12 (Unix)  (Red Hat/Linux) PHP/4.0.2 mod_perl/1.24
modt: Last-Modified: Thu, 05 Mar 1998 17:28:16 GMT
modt: Content-Length: 896
modt: Content-Type: text/html
modt:
modt: &lt;HTML&gt;&lt;HEAD&gt;&lt;TITLE&gt;Esperanto.dk&lt;/TITLE&gt;
modt: &lt;META name=&quot;description&quot; content=&quot;Den officielle danske hjemmeside om plansproget esperanto. Oficiala dana hejmpagxo pri la planlingvo Esperanto.&quot;&gt;
modt: &lt;META name=&quot;keywords&quot; content=&quot;Esperanto, Danmark, Danio, Esperanto-nyt, Zamenhof, bogsalg, plansprog, lingvistik, libroservo, planlingvo, lingvistiko&quot;&gt;
modt: &lt;/HEAD&gt;
modt: &lt;FRAMESET cols=&quot;22%,*&quot;&gt;
modt: &lt;FRAME NAME=&quot;menu&quot;    SRC=&quot;da/menu.htm&quot;     MARGINWIDTH=0&gt;
modt: &lt;FRAME NAME=&quot;indhold&quot; SRC=&quot;da/velkomst.htm&quot;&gt;
modt: &lt;NOFRAMES&gt;
modt: Velkommen til Esperanto.dk!&lt;p&gt;
modt: G&aring; til &lt;a href=&quot;da/velkomst.htm&quot;&gt;velkomst-siden&lt;/a&gt;,
modt: eller til &lt;a href=&quot;da/menu.htm&quot;&gt;indholdsfortegnelsen&lt;/a&gt;.
modt: &lt;/NOFRAMES&gt;
modt: &lt;/FRAMESET&gt;
modt: &lt;/HTML&gt;</PRE><P CLASS="western">
Det ses, at svaret starter med et hoved med metadata, der beskriver
indholdet (dato, v&aelig;rtens styresystem, hvorn&aring;r
dokumentet sidst blev &aelig;ndret, l&aelig;ngde, type). 
</P>
<P CLASS="western">Derefter kommer en blank linje og s&aring; selve
indholdet (HTML-kode).</P>
<P CLASS="western">Dette er i overensstemmelse med m&aring;den, som
data skal sendes p&aring; if&oslash;lge HTTP-protokollen. Protokollen
er l&oslash;bende blevet udbygget. En af de tidligste (og dermed
simpleste) var HTTP/0.9, mens de fleste moderne programmer bruger
HTTP/1.1.</P>
<H2 CLASS="western">16.2 <a name='afsn16.2'></a>At lytte p&aring; en port</SPAN></H2>
<P CLASS="western">For at lave et program, der fungerer som v&aelig;rt
(dvs. som andre maskiner/programmer kan forbinde sig til), opretter
man et ServerSocket-objekt, der accepterer anmodninger p&aring; en
bestemt port:</P>
<PRE CLASS="kode-western">      ServerSocket v&aelig;rtssokkel = new ServerSocket(8001);</PRE>
<P CLASS="western">Nu lytter vi p&aring; port 8001. S&aring; er det
bare at vente p&aring;, at der kommer en anmodning:</P>
<PRE CLASS="kode-western">      Socket forbindelse = v&aelig;rtssokkel.accept();</PRE><P CLASS="western">
Kaldet af accept() venter p&aring;, at en klient forbinder sig og n&aring;r
det sker, returnerer kaldet med en forbindelse til klienten i et
Socket-objekt.</P>

<P CLASS="western">Derefter kan vi arbejde med forbindelsen ligesom
f&oslash;r. Ligesom n&aring;r to mennesker snakker sammen, har
det ikke den store betydning, hvem der startede samtalen, n&aring;r
den f&oslash;rst er kommet i gang.</P>
<P CLASS="western">I tilf&aelig;ldet med HTTP-protokollen er det
defineret, at klienten f&oslash;rst skal sp&oslash;rge og v&aelig;rten
(webserveren) derefter svare, s&aring; vi l&aelig;ser f&oslash;rst en
anmodning</P>
<PRE CLASS="kode-western">      String anmodning = ind.readLine();
      System.out.println(&quot;Anmodning: &quot;+anmodning);</PRE><P CLASS="western">
... og sender derefter et svar, t&oslash;mmer databufferen og lukker
forbindelsen:</P>
<PRE CLASS="kode-western">        ud.println(&quot;HTTP/0.9 200 OK&quot;);
        ud.println();
        ud.println(&quot;&lt;html&gt;&lt;head&gt;&lt;title&gt;Svar&lt;/title&gt;&lt;/head&gt;&quot;);
        ud.println(&quot;&lt;body&gt;&lt;h1&gt;K&aelig;re bruger&lt;/h1&gt;&quot;);
        ud.println(&quot;Du har spurgt om &quot;+anmodning+&quot;, men der er intet her.&quot;);
        ud.println(&quot;&lt;/body&gt;&lt;/html&gt;&quot;);
        ud.flush();
        forbindelse.close();</PRE><P CLASS="western">
Bem&aelig;rk, at ud.flush() skal ske, f&oslash;r vi lukker
forbindelsen, ellers g&aring;r svaret helt eller delvist tabt;
Socket-objektet ved ikke, om datastr&oslash;mmen har nogle data
liggende, der ikke er blevet sendt endnu.</P>
<P CLASS="western">Herunder ses det fulde program.</P>
<PRE CLASS="kode-western" STYLE="">import java.io.*;
import java.net.*;
public class Hjemmesidevaert
{
  public static void main(String[] arg)
  {
    try {
      ServerSocket <B>v&aelig;rtssokkel = new ServerSocket(8001)</B>;
      while (true)
      {
        Socket <B>forbindelse = v&aelig;rtssokkel.accept()</B>;
        PrintWriter <B>ud = new PrintWriter(forbindelse.getOutputStream())</B>;

        BufferedReader <B>ind = new BufferedReader(</B>
<B>          new InputStreamReader(forbindelse.getInputStream()))</B>;

        String anmodning = <B>ind.readLine()</B>;
        System.out.println(&quot;Anmodning: &quot;+anmodning);

<B>        ud.println(&quot;HTTP/0.9 200 OK&quot;);</B>
<B>        ud.println();</B>
<B>        ud.println(&quot;&lt;html&gt;&lt;head&gt;&lt;title&gt;Svar&lt;/title&gt;&lt;/head&gt;&quot;);</B>
        ud.println(&quot;&lt;body&gt;&lt;h1&gt;K&aelig;re bruger&lt;/h1&gt;&quot;);
        ud.println(&quot;Du har spurgt om &quot;+anmodning+&quot;, men der er intet her.&quot;);
        ud.println(&quot;&lt;/body&gt;&lt;/html&gt;&quot;);
        <B>ud.flush()</B>;
        <B>forbindelse.close()</B>;
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">Anmodning: GET / HTTP/0.9
Anmodning: GET / HTTP/1.1
Anmodning: GET /xx.html HTTP/1.1</PRE><P CLASS="western" STYLE="font-weight: medium">
Du kan afpr&oslash;ve programmet ved at &aelig;ndre p&aring;
HentHjemmeside.java til at sp&oslash;rge 'localhost' p&aring;
port 8001 eller ved i en netl&aelig;ser at &aring;bne adressen
<A CLASS="western" HREF="http://localhost:8001/xx.html">http://localhost:8001/xx.html</A>
</P>
<H2 CLASS="western">16.3 <a name='afsn16.3'></a>URL-klassen</SPAN></H2>
<P CLASS="western">HTTP-foresp&oslash;rgsler kan egentligt klares
nemmere ved, at man bruger URL-klassen, der er indrettet til netop
dette (og som tager h&oslash;jde for eventuelle brandmure og proxyer)
og som tillader at arbejde p&aring; et mere overordnet niveau, uden
at kende til detaljerne i HTTP-protokollen. Herunder er
HentHjemmeside igen, men hvor URL-klassen bruges i stedet.</P>
<PRE CLASS="kode-western">import java.io.*;
import java.net.*;
public class HentHjemmesideMedURL
{
  public static void main(String[] arg)
  {
    try {
      URL <B>url = new URL(&quot;http://www.esperanto.dk&quot;)</B>;
      InputStream bin&aelig;rInd = <B>url.openStream()</B>;
      BufferedReader ind = new BufferedReader(new InputStreamReader(bin&aelig;rInd));
      String s = ind.readLine();
      while (s != null)
      {
        System.out.println(&quot;modt: &quot;+s);
        s = ind.readLine();
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}</PRE>
<HR>
<PRE CLASS="kode-western">modt: &lt;HTML&gt;&lt;HEAD&gt;&lt;TITLE&gt;Esperanto.dk&lt;/TITLE&gt;
modt: &lt;META name=&quot;description&quot; content=&quot;Den officielle danske hjemmeside om plansproget esperanto. Oficiala dana hejmpagxo pri la planlingvo Esperanto.&quot;&gt;
...</PRE><P CLASS="western">
Faktisk er URL-klassen meget kapabel og underst&oslash;tter mere end
HTTP-protokollen.</P>
<P CLASS="western">Man kan &aring;bne en fil p&aring; filsystemet med
f.eks.:</P>
<PRE CLASS="kode-western">new URL(&quot;file:sti/filnavn.txt&quot;)</PRE><P CLASS="western">
Man kan endda &aring;bne et jar- eller zip-arkiv (her arkiv.jar) og
l&aelig;se en fil fra det:</P>
<PRE CLASS="kode-western">new URL(&quot;jar:file:arkiv.jar!/fil_i_arkivet.txt&quot;)</PRE><P CLASS="western">
Man kan ogs&aring; bruge anonym FTP til at hente filer og liste
mapper:</P>
<PRE CLASS="kode-western">new URL(&quot;ftp://sunsite.dk/&quot;)</PRE><P CLASS="western">
... eller logge ind med <SPAN STYLE="font-weight: medium">brugernavn
og adgangskode</SPAN>:</P>
<PRE CLASS="kode-western" STYLE="font-weight: medium">new URL(&quot;ftp://brugernavn:adgangskode@ftp.v&aelig;rt.dk/fil.txt&quot;)</PRE><P CLASS="western">
URL-klassen underst&oslash;tter ikke at gemme filer (hverken p&aring;
disk eller over FTP/HTTP).</P>
<H2 CLASS="western">16.4 <a name='afsn16.4'></a>Opgaver</SPAN></H2>
<OL>
  <LI><P CLASS="western">Lav Hjemmesidevaert om, s&aring; den,
  afh&aelig;ngig af anmodningen, kan give tre forskellige svar.</P>
  <LI><P CLASS="western">Skriv HentHjemmeside om, s&aring; den sp&oslash;rger
  den lokale maskine ('localhost') port 8001 og brug den til at teste
  Hjemmesidevaert (der k&oslash;res i en separat proces).</P>
  <LI><P CLASS="western">Lav en virtuel opslagstavle. Den skal best&aring;
  af klasserne Opslagstavletjeneste, som udbyder tjenesten
  (brugport 8002) og Opslagstavleklient, som forbinder sig til
  tjenesten. Opslagstavletjeneste skal underst&oslash;tte to former
  for anmodninger: 1) TILF&Oslash;J, der f&oslash;jer en besked til
  opslagstavlen og 2) HENTALLE, der sender alle opslag til klienten.
  Afpr&oslash;v begge slags anmodninger fra Opslagstavleklient.</P>
  <LI><P CLASS="western">Lav din egen mellemv&aelig;rt (eng.: proxy -
  betyder egentlig 'str&aring;mand'), der modtager en
  HTTP-foresp&oslash;rgsel og sp&oslash;rger videre for klienten.</P>
  <LI><P CLASS="western">Pr&oslash;v hver af de andre eksempler p&aring;
  URL-adresser i HentHjemmesideMedURL.</P>
</OL>

<H2 CLASS="western" STYLE="">16.5 <a name='afsn16.5'></a>Avanceret</SPAN></H2>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel16.jsp#afsn16.5">
  <input type='checkbox' name='vis' value='16.5'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='16.5'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">16.5.1 <a name='afsn16.5.1'></a>FTP-kommunikation</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel16.jsp#afsn16.5.1">
  <input type='checkbox' name='vis' value='16.5.1'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='16.5.1'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  <H3 CLASS="western">16.5.2 <a name='afsn16.5.2'></a>Brug af FTP fra en applet</H3>

	    Dette afsnit er ikke omfattet af ben Dokumentslicens.<br>
	    Du skal <a href="/index_OOP.html#bestil">kbe</a> bogen for at
	    mtte lse dette afsnit.

  <form action="http://javabog.dk/OOP3/kapitel16.jsp#afsn16.5.2">
  <input type='checkbox' name='vis' value='16.5.2'>Jeg erklrer, at jeg allerede har kbt bogen<br />
  <input type='checkbox' name='vis' value='16.5.2'>Jeg lover at anskaffe den i nr fremtid.<br />
  <input type='submit' value='Vis mig dette afsnit'>
  </form>

	  
<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>For
  den nye version af IP-protokollen, IPv6, som man regner med vil sl&aring;
  igennem omkring &aring;r 2005, er det 16 byte. Den gamle vil dog
  blive underst&oslash;ttet mange &aring;r frem.</P>
</DIV>
<DIV ID="sdfootnote2">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote2sym" HREF="#sdfootnote2anc">2</A>Netop
  HTTP kan egentligt klares nemmere med URL-klassen (se senere). Vi
  bruger Socket-klassen i det f&oslash;lgende, da den kan anvendes til
  alle former for netv&aelig;rkskommunikation.</P>
</DIV>
<DIV ID="sdfootnote3">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote3sym" HREF="#sdfootnote3anc">3</A>I
  virkeligheden tager det noget tid, f&oslash;r data n&aring;r frem
  til klienten, men s&aring; vil read-metoderne <I>blokere</I><SPAN STYLE="font-style: normal">,
  dvs. vente p&aring;, at der er data.</SPAN></P>
</DIV>
<DIV ID="sdfootnote4">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote4sym" HREF="#sdfootnote4anc">4</A>Meddelelser
  kunne ogs&aring; hentes med URL-klassen, s&aring;dan at de kunne ses
  uden adgangskode. Husk da, at protokollerne FTP og HTTP er ret
  forskellige, blandt andet g&aring;r FTP ud fra brugerens
  hjemkatalog, mens hjemmeside-adresser ofte ligger i et underkatalog,
  der hedder public_html. F.eks. svarer &quot;PUT
  public_html/opslag/opslag.txt&quot; fra FTP-protokollen i
  HTTP-protokollen til URL'en
  &quot;http://pingo.cv.ihk.dk/~jano/opslag/opslag.txt&quot; p&aring;
  min maskine.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel15.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel17.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_OOP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b></b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (82% af vrket).
</font>
<br>
nsker du at se de sidste 18% af dette vrk (199974 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
